<div class="overflow pj-form form">
	<p>
		<label class="title"><?php __('lblTotalPassengers'); ?>:</label>
		<span class="inline_block" >
			<label class="content"><?php echo $tpl['total_passengers']; ?></label>
		</span>
	</p>
	<?php
	foreach($tpl['ticket_arr'] as $v)
	{
		?>
		<p>
			<label class="title"><?php echo $v['title']; ?>:</label>
			<span class="inline_block" >
				<label class="content"><?php echo $v['total_tickets']; ?></label>
			</span>
		</p>
		<?php
	} 
	?>
	<p style="display: none;">
		<label class="title"><?php __('lblTotalBookings'); ?>:</label>
		<span class="inline_block" >
			<label class="content"><?php echo $tpl['total_bookings']; ?></label>
		</span>
	</p>
</div>
<div class="b10">
	<table width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td class="bold"><?php __('lblBus')?>:&nbsp;<?php echo $tpl['bus_arr']['route']?>, <?php echo pjUtil::formatTime($tpl['bus_arr']['departure_time'], 'H:i:s', $tpl['option_arr']['o_time_format'])?> - <?php echo pjUtil::formatTime($tpl['bus_arr']['arrival_time'], 'H:i:s', $tpl['option_arr']['o_time_format'])?></td>
			<td align="right" class="bold"><?php __('lblDate');?>:&nbsp;<?php echo $_GET['date']?></td>
		</tr>
	</table>
</div>
<table class="pj-table" cellspacing="0" cellpadding="0" style="width: 100%;">
	<thead>
		<tr>
			<th style="width: 40px;"><?php __('lblPassengerNo');?></th>
			<th style="width: 120px;"><?php __('lblPassengerPassengerName');?></th>
			<th><?php __('lblPassengerCountry');?></th>
			<th><?php __('lblPassengerBookingID');?></th>
			<th><?php __('lblFrom');?></th>
			<th><?php __('lblTo');?></th>
			<th><?php __('lblPassengerTicketType');?></th>
			<th><?php __('lblSeats');?></th>
			<th><?php __('lblPassengerSalesAgents');?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if(count($tpl['booking_arr']) > 0)
		{
			$person_titles = __('personal_titles', true, false);
			$count = 1;
			foreach($tpl['booking_arr'] as $v)
			{
				$tickets = $v['tickets'];
				$cnt_tickets = count($tickets);
				$seats = join(", ", $v['seats']);
				$client_name_arr = array();
				if(!empty($v['c_title']))
				{
					$client_name_arr[] = $person_titles[$v['c_title']];
				}
				if(!empty($v['c_fname']))
				{
					$client_name_arr[] = pjSanitize::clean($v['c_fname']);
				}
				if(!empty($v['c_lname']))
				{
					$client_name_arr[] = pjSanitize::clean($v['c_lname']);
				}
				if ($v['booking_ticket']) {
					foreach ($v['booking_ticket'] as $k => $bt) { 
						if($k == 0) {
						?>
						<tr>
							<td colspan="2" rowspan="<?php echo $cnt_tickets;?>" style="padding: 0;">
								<?php if ($v['seats_data']) { ?>
									<table class="pj-inner-table" cellspacing="0" cellpadding="0" style="width: 100%;">
									<?php foreach ($v['seats_data'] as $j => $bs) { ?>
										<tr>
											<td style="width: 40px;"><?php echo $count;?></td>
											<td style="width: 120px;"><?php echo pjSanitize::html($bs['name']);?></td>
										</tr>								
									<?php $count++;} ?>
									</table>
								<?php } ?>
							</td>
							<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::html($v['country_title']);?></td>
							<td rowspan="<?php echo $cnt_tickets;?>">
								<?php if ($controller->isViewer()) { ?>
									<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionView&amp;id=<?php echo $v['id']?>"><?php echo pjSanitize::html($v['uuid']);?></a>
								<?php } else { ?>
									<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&amp;id=<?php echo $v['id']?>"><?php echo pjSanitize::html($v['uuid']);?></a>
								<?php } ?>
							</td>
							<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::clean($v['from_location']);?></td>
							<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::clean($v['to_location']);?></td>
							<td><?php echo pjSanitize::html($bt['ticket']);?> x <?php echo $bt['qty'];?></td>
							<td rowspan="<?php echo $cnt_tickets;?>" align="center"><?php echo count($v['seats_data']);?></td>
							<td rowspan="<?php echo $cnt_tickets;?>"><?php echo !empty($v['agent_email']) ? (pjSanitize::html($v['agent_name']).'('.pjSanitize::html($v['agent_email']).')') : null;?></td>
						</tr>
					<?php 
						} else { ?>
						<tr>
							<td><?php echo pjSanitize::html($bt['ticket']);?> x <?php echo $bt['qty'];?></td>
						</tr>
						<?php 
						}
					} 
				}
			} ?>
			<tr class="pj-total-seats">
				<td colspan="6">&nbsp;</td>
				<td><?php __('lblPassengerTotalSeats');?></td>
				<td colspan="2"><?php echo ($count-1);?></td>
			</tr>
			<?php 
		} else {
			?>
			<tr>
				<td colspan="9"><?php __('gridEmptyResult');?></td>
			</tr>
			<?php
		}
		?>
	</tbody>
</table>