<?php
$front_messages = __('front_messages', true, false);

switch ($tpl['arr']['payment_method'])
{
	case 'paypal':
		?><div class="bsSystemMessage"><?php echo $front_messages[1]; ?></div><?php
		if (pjObject::getPlugin('pjPaypal') !== NULL)
		{
			$controller->requestAction(array('controller' => 'pjPaypal', 'action' => 'pjActionForm', 'params' => $tpl['params']));
		}
		break;
	case 'authorize':
		?><div class="bsSystemMessage"><?php echo $front_messages[2]; ?></div><?php
		if (pjObject::getPlugin('pjAuthorize') !== NULL)
		{
			$controller->requestAction(array('controller' => 'pjAuthorize', 'action' => 'pjActionForm', 'params' => $tpl['params']));
		}
		break;
	case 'nicepay':
		?><div class="bsSystemMessage"><?php echo $front_messages[7]; ?></div><?php
		require_once PJ_CONTROLLERS_PATH . 'components/Nicepay/NicepayLib.php';
		$merchant_id = $tpl['option_arr']['o_nicepay_merchant_id'];
		$merchant_key = $tpl['option_arr']['o_nicepay_merchant_key'];
		$thankyou_url = $tpl['option_arr']['o_thank_you_page'];
		$notify_url = PJ_INSTALL_URL . 'nicepay_confirmation.php';
		$nicepay = new NicepayLib($merchant_id, $merchant_key, $thankyou_url, $notify_url);
		
		// Populate Mandatory parameters to send
        $nicepay->set('payMethod', '01');
        $nicepay->set('currency', 'IDR');
        $nicepay->set('amt', round($tpl['arr']['deposit'])); // Total gross amount
        $nicepay->set('referenceNo', $tpl['arr']['uuid']); // Invoice Number or Referenc Number Generated by merchant
        $nicepay->set('description', __('front_label_bus_schedule', true, false).' - '.$tpl['arr']['uuid']); // Transaction description

        $name_arr = array();
        if (!empty($tpl['arr']['c_fname'])) {
        	$name_arr[] = $tpl['arr']['c_fname'];
        }
		if (!empty($tpl['arr']['c_lname'])) {
        	$name_arr[] = $tpl['arr']['c_lname'];
        }
        if ($name_arr) {
        	$nicepay->set('billingNm', implode(" ", $name_arr)); // Customer name
        	$nicepay->set('deliveryNm', implode(" ", $name_arr)); // Delivery name
        } else {
        	$nicepay->set('billingNm', 'Unknow'); // Customer name
        	$nicepay->set('deliveryNm', 'Unknow'); // Delivery name
        }
        if (!empty($tpl['arr']['c_phone'])) {
        	$nicepay->set('billingPhone', $tpl['arr']['c_phone']); // Customer phone number
        	$nicepay->set('deliveryPhone', $tpl['arr']['c_phone']);
        } else {
        	$nicepay->set('billingPhone', 'Unknow'); // Customer phone number
        	$nicepay->set('deliveryPhone', 'Unknow');
        }
        if (!empty($tpl['arr']['c_email'])) {
        	$nicepay->set('billingEmail', $tpl['arr']['c_email']);
        	$nicepay->set('deliveryEmail', $tpl['arr']['c_email']);
        } else {
        	$nicepay->set('billingEmail', 'unknow@email.com');
        	$nicepay->set('deliveryEmail', 'unknow@email.com');
        }
        if (!empty($tpl['arr']['c_address'])) {
        	$nicepay->set('billingAddr', $tpl['arr']['c_address']);
        	$nicepay->set('deliveryAddr', $tpl['arr']['c_address']);
        } else {
        	$nicepay->set('billingAddr', 'Unknow');
        	$nicepay->set('deliveryAddr', 'Unknow');
        }
        if (!empty($tpl['arr']['c_city'])) {
        	$nicepay->set('billingCity', $tpl['arr']['c_city']);
        	$nicepay->set('deliveryCity', $tpl['arr']['c_city']);
        } else {
        	$nicepay->set('billingCity', 'Unknow');
        	$nicepay->set('deliveryCity', 'Unknow');
        }
        if (!empty($tpl['arr']['c_state'])) { 
        	$nicepay->set('billingState', $tpl['arr']['c_state']);
        	$nicepay->set('deliveryState', $tpl['arr']['c_state']);
        } else {
        	$nicepay->set('billingState', 'Unknow');
        	$nicepay->set('deliveryState', 'Unknow');
        }
        if (!empty($tpl['arr']['c_zip'])) {
        	$nicepay->set('billingPostCd', $tpl['arr']['c_zip']);
        	$nicepay->set('deliveryPostCd', $tpl['arr']['c_zip']);
        } else {
        	$nicepay->set('billingPostCd', 'Unknow');
        	$nicepay->set('deliveryPostCd', 'Unknow');
        }  
        if (!empty($tpl['arr']['country_title'])) {
        	$nicepay->set('billingCountry', substr($tpl['arr']['country_title'], 0, 10));
            $nicepay->set('deliveryCountry', substr($tpl['arr']['country_title'], 0, 10));
        } else {
        	$nicepay->set('billingCountry', 'Indonesia');
        	$nicepay->set('deliveryCountry', 'Indonesia');
        }        
        
        // Send Data
        $response = $nicepay->chargeCard();

        // Response from NICEPAY
//        var_dump($response);
//        exit();
        if (isset($response->data->resultCd) && $response->data->resultCd == "0000") { ?>
        	<input type="hidden" name="nicepay_payment_url" id="nicepay_payment_url_<?php echo $_GET['index'];?>" value="<?php echo $response->data->requestURL;?>?tXid=<?php echo $response->tXid;?>&optDisplayCB=1" />
        	<a class="btn btn-primary bsNicepayPaymentUrl" href="<?php echo $response->data->requestURL;?>?tXid=<?php echo $response->tXid;?>"><?php __('front_btn_goto_payment_page');?></a>
        	<?php 
              //header("Location: ".$response->data->requestURL."?tXid=".$response->tXid);
//            please save tXid in your database
//            echo "<pre>";
//            echo "tXid              : $response->tXid\n";
//            echo "API Type          : $response->apiType\n";
//            echo "Request Date      : $response->requestDate\n";
//            echo "Response Date     : $response->requestDate\n";
//            echo "</pre>";
        } elseif(isset($response->data->resultCd)) {
            // API data not correct or error happened in bank system, you can redirect back to checkout page or echo error message.
            // In this sample, we echo error message
            // header("Location: "."http://example.com/checkout.php");          
            echo "result code       : ".$response->data->resultCd."<br/>";
            echo "result message    : ".$response->data->resultMsg."<br/>";
            echo '<a href="#" class="bsStartOver">'.__('front_start_over', true).'</a>';
//            echo "requestUrl        : ".$response->data->requestURL."\n";
        } else {
            // Timeout, you can redirect back to checkout page or echo error message.
            // In this sample, we echo error message
            // header("Location: "."http://example.com/checkout.php");
            echo 'Connection Timeout. Please Try again. <a href="#" class="bsStartOver">'.__('front_start_over', true).'</a>';
        }
        
		break;
	case 'nicepay_virtual':
		/*?><div class="bsSystemMessage"><?php echo $front_messages[8]; ?></div><?php*/
		$bankCd = $tpl['arr']['bankCd'];
        $dateNow = date('Ymd');
        $timeNow = date('His');
        $vaExpiryTime = date('His', strtotime($timeNow . ' +30 minutes'));

        require_once PJ_CONTROLLERS_PATH . 'components/NicepayEnterprise/NicepayLib.php';
		$merchant_id = $tpl['option_arr']['o_nicepay_merchant_id'];
		$merchant_key = $tpl['option_arr']['o_nicepay_merchant_key'];
		$thankyou_url = $tpl['option_arr']['o_thank_you_page'];
		$notify_url = PJ_INSTALL_URL . 'nicepay_virtual_confirmation.php';
		$nicepay = new NicepayLib($merchant_id, $merchant_key, $thankyou_url, $notify_url);
		
		// Populate Mandatory parameters to send
        $nicepay->set('payMethod', '02');
        $nicepay->set('currency', 'IDR');
        $nicepay->set('amt', round($tpl['arr']['deposit'])); // Total gross amount
        $nicepay->set('referenceNo', $tpl['arr']['uuid']); // Invoice Number or Referenc Number Generated by merchant
        $nicepay->set('description', __('front_label_bus_schedule', true, false).' - '.$tpl['arr']['uuid']); // Transaction description
        $nicepay->set('bankCd', $bankCd);

		$name_arr = array();
        if (!empty($tpl['arr']['c_fname'])) {
        	$name_arr[] = $tpl['arr']['c_fname'];
        }
		if (!empty($tpl['arr']['c_lname'])) {
        	$name_arr[] = $tpl['arr']['c_lname'];
        }
        if ($name_arr) {
        	$nicepay->set('billingNm', implode(" ", $name_arr)); // Customer name
        	$nicepay->set('deliveryNm', implode(" ", $name_arr)); // Delivery name
        } else {
        	$nicepay->set('billingNm', 'Unknow'); // Customer name
        	$nicepay->set('deliveryNm', 'Unknow'); // Delivery name
        }
        if (!empty($tpl['arr']['c_phone'])) {
        	$nicepay->set('billingPhone', $tpl['arr']['c_phone']); // Customer phone number
        	$nicepay->set('deliveryPhone', $tpl['arr']['c_phone']);
        } else {
        	$nicepay->set('billingPhone', 'Unknow'); // Customer phone number
        	$nicepay->set('deliveryPhone', 'Unknow');
        }
        if (!empty($tpl['arr']['c_email'])) {
        	$nicepay->set('billingEmail', $tpl['arr']['c_email']);
        	$nicepay->set('deliveryEmail', $tpl['arr']['c_email']);
        } else {
        	$nicepay->set('billingEmail', 'unknow@email.com');
        	$nicepay->set('deliveryEmail', 'unknow@email.com');
        }
        if (!empty($tpl['arr']['c_address'])) {
        	$nicepay->set('billingAddr', $tpl['arr']['c_address']);
        	$nicepay->set('deliveryAddr', $tpl['arr']['c_address']);
        } else {
        	$nicepay->set('billingAddr', 'Unknow');
        	$nicepay->set('deliveryAddr', 'Unknow');
        }
        if (!empty($tpl['arr']['c_city'])) {
        	$nicepay->set('billingCity', $tpl['arr']['c_city']);
        	$nicepay->set('deliveryCity', $tpl['arr']['c_city']);
        } else {
        	$nicepay->set('billingCity', 'Unknow');
        	$nicepay->set('deliveryCity', 'Unknow');
        }
        if (!empty($tpl['arr']['c_state'])) { 
        	$nicepay->set('billingState', $tpl['arr']['c_state']);
        	$nicepay->set('deliveryState', $tpl['arr']['c_state']);
        } else {
        	$nicepay->set('billingState', 'Unknow');
        	$nicepay->set('deliveryState', 'Unknow');
        }
        if (!empty($tpl['arr']['c_zip'])) {
        	$nicepay->set('billingPostCd', $tpl['arr']['c_zip']);
        	$nicepay->set('deliveryPostCd', $tpl['arr']['c_zip']);
        } else {
        	$nicepay->set('billingPostCd', 'Unknow');
        	$nicepay->set('deliveryPostCd', 'Unknow');
        }  
        if (!empty($tpl['arr']['country_title'])) {
        	$nicepay->set('billingCountry', substr($tpl['arr']['country_title'], 0, 10));
            $nicepay->set('deliveryCountry', substr($tpl['arr']['country_title'], 0, 10));
        } else {
        	$nicepay->set('billingCountry', 'Indonesia');
        	$nicepay->set('deliveryCountry', 'Indonesia');
        }

        $nicepay->set('vacctValidDt', $dateNow); // Set VA expiry date example: +1 day
        $nicepay->set('vacctValidTm', $vaExpiryTime); // Set VA Expiry Time

        // Send Data
        $response = $nicepay->requestVA();
			
        // Response from NICEPAY
        // var_dump($response);
        ?>
        <div class="bsSystemMessage">
        <?php 
	        if (isset($response->resultCd) && $response->resultCd == "0000") {
		        echo "<pre>";
                        echo "<table>";
                  echo "<tr><td>Virtual Account Number (Nomor Tagihan)</td><td>:</td><td>$response->bankVacctNo</td></tr>";
                        if($response->bankCd == "CENA"){
                    echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>BCA</td></tr>";
                  }elseif ($response->bankCd == "BMRI") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>MANDIRI</td></tr>";
                  }elseif ($response->bankCd == "BBBA") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>PERMATA</td></tr>";
                  }elseif ($response->bankCd == "HNBN") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>HANA BANK</td></tr>";
                  }elseif ($response->bankCd == "BRIN") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>BRI</td></tr>";
                  }elseif ($response->bankCd == "BNIN") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>BNI</td></tr>";
                  }elseif ($response->bankCd == "BNIA") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>CIMB</td></tr>";
                  }elseif ($response->bankCd == "BDIN") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>DANAMON</td></tr>";
                  }elseif ($response->bankCd == "IBBK") {
                      echo "<tr><td>Bank Name (Nama Bank)</td><td>:</td><td>MAYBANK</td></tr>";
                  }
                        echo "<tr><td>Expiry Date of Payment (Limit Tanggal Pembayaran)</td><td>:</td><td>".date('d-m-Y', strtotime($dateNow))."</td></tr>";
                        echo "<tr><td>Expiry Time of Payment (Limit Jam Pembayaran)</td><td>:</td><td>".date('H:i:s', strtotime($vaExpiryTime))."</td></tr>";
                        echo "</table>";
                        echo "Step of payment Click (Step Pembayaran Klik) <a target='_blank' href='http://template.nicepay.co.id/'>Here (DISINI)</a>";
                echo "</pre>";
	        	echo $front_messages[9].' <a href="#" class="bsStartOver">'.__('front_start_over', true).'</a>'; 
	        } elseif(isset($response->resultCd)) {
	            // API data not correct or error happened in bank system, you can redirect back to checkout page or echo error message.
	            // In this sample, we echo error message
	            echo "Oops! Something happened, please notice your system administrator.<br/>";
	            echo "Result code       : ".$response->resultCd."<br/>";
	            echo "Result message    : ".$response->resultMsg."<br/>";
	            echo '<a href="#" class="bsStartOver">'.__('front_start_over', true).'</a>';
	        } else {
	            // Timeout, you can redirect back to checkout page or echo error message.
	            // In this sample, we echo error message
	            echo 'Connection Timeout. Please Try again. <a href="#" class="bsStartOver">'.__('front_start_over', true).'</a>';
	        }
	        ?>
	     </div>
	    <?php 
		break;
	case 'bank':
		?>
		<div class="bsSystemMessage">
			<?php
			$system_msg = str_replace("[STAG]", "<a href='#' class='bsStartOver'>", $front_messages[3]);
			$system_msg = str_replace("[ETAG]", "</a>", $system_msg); 
			echo $system_msg; 
			?>
			<br /><br />
			<?php echo pjSanitize::html(nl2br($tpl['option_arr']['o_bank_account'])); ?>
		</div>
		<?php
		break;
	case 'creditcard':
	case 'cash':
	default:
		?>
		<div class="bsSystemMessage">
			<?php
			$system_msg = str_replace("[STAG]", "<a href='#' class='bsStartOver'>", $front_messages[3]);
			$system_msg = str_replace("[ETAG]", "</a>", $system_msg); 
			echo $system_msg; 
			?>
		</div>
		<?php
}

?>